//-----------------------------------------------------------
// NewScriptedPawnTest
//
// I couldn't fix the rapidfire bug with DTR's bots, so I'm
// just going to edit Godzbots until they're suitable.
//
// Edit: These functions (Pawn) might come in handy...
//
//native(500) final latent function MoveTo( vector NewDestination, optional float speed);
//native(502) final latent function MoveToward(actor NewTarget, optional float speed);
//native(504) final latent function StrafeTo(vector NewDestination, vector NewFocus, optional float speed);  // DEUS_EX STM - added new param
//native(506) final latent function StrafeFacing(vector NewDestination, actor NewTarget, optional float speed);  // DEUS_EX STM - added new param
//native(508) final latent function TurnTo(vector NewFocus);
//native(510) final latent function TurnToward(actor NewTarget);
//
//var vector destLoc;
//-----------------------------------------------------------
class NewScriptedPawnTest expands ScriptedPawn;

var AlliancesHandler AH;
var bool bShouldChangeAlliance;
var Name NNAlliance;
Var bool bCAggressive;
var NPCRespawner Respawner;
var() bool bRespawning;
var() float TimeToRespawn;

// ----------------------------------------------------------------------
// state Attacking
//
// Kill!  Kill!  Kill!  Kill!
// ----------------------------------------------------------------------

function TakeDamageBase(int Damage, Pawn instigatedBy, Vector hitlocation, Vector momentum, name damageType,
                        bool bPlayAnim)
{
	local NewScriptedPawnTest alliez;
	local int i;

	if(bShouldChangeAlliance == True) //Just in case...
	{
		if(ClassIsChildOf(instigatedBy.Class, class'DeusExPlayer'))
		{
			AH.HandleAlliance(DeusExPlayer(instigatedBy), NNAlliance);
		}
	}

	if(health > 0)
	{
		for (i=1; i<7; i++)
		{
			//foreach RadiusActors(Class'NewScriptedPawnTest', alliez, 40 * 16) // Cozmo: Alert allies within 40 foot
			foreach AllActors(class'NewScriptedPawnTest', alliez)
			{
				if((Skin == alliez.Skin) || (Alliance == Alliez.Alliance) && (alliez != Self))
				{
 					if(alliez.Enemy == None)
 					{
 						if(CheckForPlayer())
						{
							alliez.GotoState('Attacking');
							//alliez.TakeDamage(1, Enemy, Location, vect(0,0,0), 'shot');
							alliez.SetEnemy(instigatedby);
						}
		 			}
				}
			}
		}
	}

	Super.TakeDamageBase(Damage, instigatedBy, hitlocation, momentum, damageType, bPlayAnim);
}

function Carcass SpawnCarcass()
{
	if(Respawner != None)
	{
		Respawner.SetTimer(TimeToRespawn, False);
	}
}

State Attacking
{
     function ReactToInjury(Pawn instigatedBy, Name damageType, EHitLocation hitPos)
     {
          local Pawn oldEnemy;
          local bool bHateThisInjury;
          local bool bFearThisInjury;

          if ((health > 0) && (bLookingForInjury || bLookingForIndirectInjury))
          {
               oldEnemy = Enemy;

               bHateThisInjury = ShouldReactToInjuryType(damageType, bHateInjury, bHateIndirectInjury);
               bFearThisInjury = ShouldReactToInjuryType(damageType, bFearInjury, bFearIndirectInjury);

               if (bHateThisInjury)
                    IncreaseAgitation(instigatedBy, 1.0);
               if (bFearThisInjury)
                    IncreaseFear(instigatedBy, 2.0);

               if (ReadyForNewEnemy())
		  if(IsValidEnemy(instigatedBy))
                     SetEnemy(instigatedBy);

               if (ShouldFlee())
               {
                    SetDistressTimer();
                    PlayCriticalDamageSound();
                    if (RaiseAlarm == RAISEALARM_BeforeFleeing)
                         SetNextState('Alerting');
                    else
                         SetNextState('Fleeing');
               }
               else
               {
                    SetDistressTimer();
                    if (oldEnemy != Enemy)
                         PlayNewTargetSound();
                    SetNextState('Attacking', 'ContinueAttack');
               }
               GotoDisabledState(damageType, hitPos);
          }
     }

     function SetFall()
     {
          StartFalling('Attacking', 'ContinueAttack');
     }

     function HitWall(vector HitNormal, actor Wall)
     {
          if (Physics == PHYS_Falling)
               return;
          Global.HitWall(HitNormal, Wall);
          CheckOpenDoor(HitNormal, Wall);
     }

     function Reloading(DeusExWeapon reloadWeapon, float reloadTime)
     {
          Global.Reloading(reloadWeapon, reloadTime);
          if (bReadyToReload)
               if (IsWeaponReloading())
                    if (!IsHandToHand())
                         TweenToShoot(0);
     }

     function EDestinationType PickDestination()
     {
          local vector               distVect;
          local vector               tempVect;
          local rotator              enemyDir;
          local float                magnitude;
          local float                calcMagnitude;
          local int                  iterations;
          local EDestinationType     destType;
          local NearbyProjectileList projList;

          destPoint = None;
          destLoc   = vect(0, 0, 0);
          destType  = DEST_Failure;

          if (enemy == None)
               return (destType);

          if (bCrouching && (CrouchTimer > 0))
               destType = DEST_SameLocation;

          if (destType == DEST_Failure)
          {
               if (AICanShoot(enemy, true, false, 0.025) || ActorReachable(enemy))
               {
                    destType = ComputeBestFiringPosition(tempVect);
                    if (destType == DEST_NewLocation)
                         destLoc = tempVect;
               }
          }

          if (destType == DEST_Failure)
          {
               MoveTarget = FindPathToward(enemy);
               if (MoveTarget != None)
               {
                    if (!bDefendHome || IsNearHome(MoveTarget.Location))
                    {
                         if (bAvoidHarm)
                              GetProjectileList(projList, MoveTarget.Location);
                         if (!bAvoidHarm || !IsLocationDangerous(projList, MoveTarget.Location))
                         {
                              destPoint = MoveTarget;
                              destType  = DEST_NewLocation;
                         }
                    }
               }
          }

          // Default behavior, so they don't just stand there...
          if (destType == DEST_Failure)
          {
               enemyDir = Rotator(Enemy.Location - Location);
               if (AIPickRandomDestination(60, 150,
                                           enemyDir.Yaw, 0.5, enemyDir.Pitch, 0.5,
                                           2, FRand()*0.4+0.35, tempVect))
               {
                    if (!bDefendHome || IsNearHome(tempVect))
                    {
                         destType = DEST_NewLocation;
                         destLoc  = tempVect;
                    }
               }
          }

          return (destType);
     }

     function bool FireIfClearShot()
     {
          local DeusExWeapon dxWeapon;

          dxWeapon = DeusExWeapon(Weapon);


          //MPBots EdGann KLUDGE: bReadyToFire doesn't seem to work right for Scripted Pawns
          // So I set it and execute ReadyToFire() automatically.

          dxWeapon.bReadyToFire=false;
          dxWeapon.ReadyToFire();

          if (dxWeapon != None)
          {
               if ((dxWeapon.AIFireDelay > 0) && (FireTimer > 0))
                    return false;
               else if (AICanShoot(enemy, true, true, 0.025))
               {

                    // MPBots EdGann: Changed from Fire to ClientFire.
                    Weapon.ClientFire(0);
                    FireTimer = dxWeapon.AIFireDelay;
                    return true;
               }
               else
                   return false;

          }
          else
              return false;
     }

     function CheckAttack(bool bPlaySound)
     {
          local bool bCriticalDamage;
          local bool bOutOfAmmo;
          local Pawn oldEnemy;
          local bool bAllianceSwitch;

          oldEnemy = enemy;

          bAllianceSwitch = false;
          if (!IsValidEnemy(enemy))
          {
               if (IsValidEnemy(enemy, false))
                    bAllianceSwitch = true;
               SetEnemy(None, 0, true);
          }

          if (enemy == None)
          {
               if (Orders == 'Attacking')
               {
                    FindOrderActor();
                    SetEnemy(Pawn(OrderActor), 0, true);
               }
          }
          if (ReadyForNewEnemy())
               FindBestEnemy(false);
          if (enemy == None)
          {
               Enemy = oldEnemy;  // hack
               if (bPlaySound)
               {
                    if (bAllianceSwitch)
                         PlayAllianceFriendlySound();
                    else
                         PlayAreaSecureSound();
               }
               Enemy = None;
               if (Orders != 'Attacking')
                    FollowOrders();
               else
                    GotoState('Wandering');
               return;
          }

          SwitchToBestWeapon();
          if (bCrouching && (CrouchTimer <= 0) && !ShouldCrouch())
          {
               EndCrouch();
               TweenToShoot(0.15);
          }
          bCriticalDamage = False;
          bOutOfAmmo      = False;
          if (ShouldFlee())
               bCriticalDamage = True;
          else if (Weapon == None)
               bOutOfAmmo = True;
          else if (Weapon.ReloadCount > 0)
          {
               if (Weapon.AmmoType == None)
                    bOutOfAmmo = True;
               else if (Weapon.AmmoType.AmmoAmount < 1)
                    bOutOfAmmo = True;
          }
          if (bCriticalDamage || bOutOfAmmo)
          {
               if (bPlaySound)
               {
                    if (bCriticalDamage)
                         PlayCriticalDamageSound();
                    else if (bOutOfAmmo)
                         PlayOutOfAmmoSound();
               }
               if (RaiseAlarm == RAISEALARM_BeforeFleeing)
                    GotoState('Alerting');
               else
                    GotoState('Fleeing');
          }
          else if (bPlaySound && (oldEnemy != Enemy))
               PlayNewTargetSound();
     }

     function Tick(float deltaSeconds)
     {
          local bool   bCanSee;
          local float  yaw;
          local vector lastLocation;
          local Pawn   lastEnemy;
          local float  surpriseTime;

	if(self.IsA('CozCop')) //Cozmo: More hacky crap. When will it end?
	{
		if(enemy.Alliance != 'Criminal')
		{
			enemy = none;
		}
	}

          Global.Tick(deltaSeconds);
          if (CrouchTimer > 0)
          {
               CrouchTimer -= deltaSeconds;
               if (CrouchTimer < 0)
                    CrouchTimer = 0;
          }
          EnemyTimer += deltaSeconds;
          UpdateActorVisibility(Enemy, deltaSeconds, 1.0, false);
          if ((Enemy != None) && HasEnemyTimedOut())
          {
               lastLocation = Enemy.Location;
               lastEnemy    = Enemy;
               FindBestEnemy(true);
               if (Enemy == None)
               {
                    SetSeekLocation(lastEnemy, lastLocation, SEEKTYPE_Guess, true);
                    GotoState('Seeking');
               }
          }
          else if (bCanFire && (Enemy != None))
          {
               ViewRotation = Rotator(Enemy.Location-Location);
               if (bFacingTarget)
                    FireIfClearShot();
               else if (!bMustFaceTarget)
               {
                    yaw = (ViewRotation.Yaw-Rotation.Yaw) & 0xFFFF;
                    if (yaw >= 32768)
                         yaw -= 65536;
                    yaw = Abs(yaw)*360/32768;  // 0-180 x 2
                    if (yaw <= FireAngle)
                         FireIfClearShot();
               }
          }
          //UpdateReactionLevel(true, deltaSeconds);
     }

     function bool IsHandToHand()
     {
          if (Weapon != None)
          {
               if (DeusExWeapon(Weapon) != None)
               {
                    if (DeusExWeapon(Weapon).bHandToHand)
                         return true;
                    else
                         return false;
               }
               else
                    return false;
          }
          else
               return false;
     }

     function bool ReadyForWeapon()
     {
          local bool bReady;

          bReady = false;
          if (DeusExWeapon(weapon) != None)
          {
               if (DeusExWeapon(weapon).bReadyToFire)
                    if (!IsWeaponReloading())
                         bReady = true;
          }
          if (!bReady)
               if (enemy == None)
                    bReady = true;
          if (!bReady)
               if (!AICanShoot(enemy, true, false, 0.025))
                    bReady = true;

          return (bReady);
     }

     function bool ShouldCrouch()
     {
          if (bCanCrouch && !Region.Zone.bWaterZone && !IsHandToHand() &&
              ((enemy != None) && (VSize(enemy.Location-Location) > 300)) &&
              ((DeusExWeapon(Weapon) == None) || DeusExWeapon(Weapon).bUseWhileCrouched))
               return true;
          else
               return false;
     }

     function StartCrouch()
     {
          if (!bCrouching)
          {
               bCrouching = true;
               SetBasedPawnSize(CollisionRadius, GetCrouchHeight());
               CrouchTimer = 1.0+FRand()*0.5;
          }
     }

     function EndCrouch()
     {
          if (bCrouching)
          {
               bCrouching = false;
               ResetBasedPawnSize();
          }
     }

     function BeginState()
     {
          StandUp();

          // hack
          if (MaxRange < MinRange+10)
               MaxRange = MinRange+10;
          bCanFire      = false;
          bFacingTarget = false;

          SwitchToBestWeapon();

          //EnemyLastSeen = 0;
          BlockReactions();
          bCanConverse = False;
          bAttacking = True;
          bStasis = False;
          SetDistress(true);

          CrouchTimer = 0;
          EnableCheckDestLoc(false);
     }

     function EndState()
     {
          EnableCheckDestLoc(false);
          bCanFire      = false;
          bFacingTarget = false;

          ResetReactions();
          bCanConverse = True;
          bAttacking = False;
          bStasis = True;
          bReadyToReload = false;

          EndCrouch();
     }

Begin:
     if (Enemy == None)
          GotoState('Seeking');
     //EnemyLastSeen = 0;
     CheckAttack(false);

Surprise:
     if ((1.0-ReactionLevel)*SurprisePeriod < 0.25)
          Goto('BeginAttack');
     Acceleration=vect(0,0,0);
     PlaySurpriseSound();
     PlayWaiting();
     while (ReactionLevel < 1.0)
     {
          TurnToward(Enemy);
          Sleep(0);
     }

BeginAttack:
     EnemyReadiness = 1.0;
     ReactionLevel  = 1.0;
     if (PlayerAgitationTimer > 0)
          PlayAllianceHostileSound();
     else
          PlayTargetAcquiredSound();
     if (PlayBeginAttack())
     {
          Acceleration = vect(0,0,0);
          TurnToward(enemy);
          FinishAnim();
     }

RunToRange:
     bCanFire       = false;
     bFacingTarget  = false;
     bReadyToReload = false;
     EndCrouch();
     if (Physics == PHYS_Falling)
          TweenToRunning(0.05);
     WaitForLanding();
     if (!IsWeaponReloading() || bCrouching)
     {
          if (ShouldPlayTurn(Enemy.Location))
               PlayTurning();
          TurnToward(enemy);
     }
     else
          Sleep(0);
     bCanFire = true;
     while (PickDestination() == DEST_NewLocation)
     {
          if (bCanStrafe && ShouldStrafe())
          {
               PlayRunningAndFiring();
               if (destPoint != None)
                    StrafeFacing(destPoint.Location, enemy);
               else
                    StrafeFacing(destLoc, enemy);
               bFacingTarget = true;
          }
          else
          {
               bFacingTarget = false;
               PlayRunning();
               if (destPoint != None)
                    MoveToward(destPoint, MaxDesiredSpeed);
               else
                    MoveTo(destLoc, MaxDesiredSpeed);
          }
          CheckAttack(true);
     }

Fire:
     bCanFire      = false;
     bFacingTarget = false;
     Acceleration = vect(0, 0, 0);

     SwitchToBestWeapon();
     if (FRand() > 0.5)
          bUseSecondaryAttack = true;
     else
          bUseSecondaryAttack = false;
     if (IsHandToHand())
          TweenToAttack(0.15);
     else if (ShouldCrouch() && (FRand() < CrouchRate))
     {
          TweenToCrouchShoot(0.15);
          FinishAnim();
          StartCrouch();
     }
     else
          TweenToShoot(0.15);
     if (!IsWeaponReloading() || bCrouching)
          TurnToward(enemy);
     FinishAnim();
     bReadyToReload = true;

ContinueFire:
     while (!ReadyForWeapon())
     {
          if (PickDestination() != DEST_SameLocation)
               Goto('RunToRange');
          CheckAttack(true);
          if (!IsWeaponReloading() || bCrouching)
               TurnToward(enemy);
          else
               Sleep(0);
     }
     CheckAttack(true);
     if (!FireIfClearShot())
          Goto('ContinueAttack');
     bReadyToReload = false;
     if (bCrouching)
          PlayCrouchShoot();
     else if (IsHandToHand())
          PlayAttack();
     else
          PlayShoot();
     FinishAnim();
     if (FRand() > 0.5)
          bUseSecondaryAttack = true;
     else
          bUseSecondaryAttack = false;
     bReadyToReload = true;
     if (!IsHandToHand())
     {
          if (bCrouching)
               TweenToCrouchShoot(0);
          else
               TweenToShoot(0);
     }
     CheckAttack(true);
     if (PickDestination() != DEST_NewLocation)
     {
          if (!IsWeaponReloading() || bCrouching)
               TurnToward(enemy);
          else
               Sleep(0);
          Goto('ContinueFire');
     }
     Goto('RunToRange');

ContinueAttack:
ContinueFromDoor:
     CheckAttack(true);
     if (PickDestination() != DEST_NewLocation)
          Goto('Fire');
     else
          Goto('RunToRange');

}

function Timer() // Cozmo: Replacing Tick(); insane ammounts of lag.
{
	if(Enemy == None)
	{
		if(CheckForPlayer())
		{
			//GotoState('Attacking');
			//TakeDamage(1, Enemy, Location, vect(0,0,0), 'shot'); //Cozmo: And the world's laziest coder award goes to...
			//I don't think the TakeDamage thing works in these new bots?
		}
	}
	else
	{
		if(Enemy.Skin == Skin)
		{
			Enemy = none;
		}
	}
}

function bool CheckForPlayer() //Cozmo: Took this (from DTR's code), modified it and added it here.)
{
	local DeusExPlayer mpPlayer;

	foreach VisibleActors(class'DeusExPlayer', mpPlayer, 100 * 16) // A TEST
	{
		if(mpPlayer.Health > 0) // Cozmo: To stop attacker twitching
		{
			if(IsValidMPEnemy(mpPlayer))
			{
				//if(self.IsA('FreakOfTheSlums')) //Cozmo: I know it's stupid. Class is acting weird though so no choice.
				//{
				//	TakeDamage(1, Enemy, Location, vect(0,0,0), 'shot');
				//	SetEnemy(mpPlayer);
				//	return true;
				//}
				//else
				//{
				//	SetEnemy(mpPlayer);
				//	return true;
				//}
			}
		}
	}

	return false;
}

function bool IsValidMPEnemy(Pawn potEnemy) // Cozmo: NPCs keep attacking their allies! Annoying!
{
	if(potEnemy != None)
	{
    		if(potEnemy.Health <= 0)
		return false;

		if(Texture != potEnemy.Texture)
		{
    			return true;
		}
	}

	return false;
}

function BeginPlay()
{
	local AlliancesHandler VAH;

	Super.BeginPlay();

	foreach AllActors(Class'AlliancesHandler',VAH)
	{
		AH = VAH;
	}

     // change the sounds for chicks
     if (bIsFemale)
     {
          HitSound1 = Sound'FemalePainMedium';
          HitSound2 = Sound'FemalePainLarge';
          Die = Sound'FemaleDeath';
     }

	if(bRespawning == true)
	{
		if(Respawner == None)
		{
			Respawner = Spawn(Class'NPCRespawner',,, location, rotation);
			Respawner.NSP = Class;
			Respawner.OOrders = Orders;
			Respawner.Ploc = Location;
			Respawner.Prot = Rotation;
		}
	}

	//if(bCAggressive == True) //Stupid outdated system. Remove?
	//{
	//	if(self.IsA('FreakOfTheSlums'))
	//	{
	//		SetTimer(0.4, true);
	//	}
	//	else
	//	{
	//		SetTimer(1.5, true);
	//	}
	//}
}

function bool WillTakeStompDamage(actor stomper)
{
     // This blows chunks!
     if (stomper.IsA('PlayerPawn') && (GetPawnAllianceType(Pawn(stomper)) != ALLIANCE_Hostile))
          return false;
     else
          return true;
}

//---END-CLASS---

defaultproperties
{
     TimeToRespawn=90.000000
     bRespawning=false
     bShouldChangeAlliance=True
     bKeepWeaponDrawn=True
     BaseAccuracy=0.200000
     maxRange=1000.000000
     MinHealth=20.000000
     bPlayIdle=True
     bAimForHead=True
     bCanCrouch=True
     bSprint=True
     CrouchRate=1.000000
     SprintRate=1.000000
     bReactAlarm=True
     RaiseAlarm=RAISEALARM_Never
     EnemyTimeout=5.000000
     bCanTurnHead=True
     WaterSpeed=80.000000
     AirSpeed=160.000000
     AccelRate=500.000000
     BaseEyeHeight=40.000000
     UnderWaterTime=20.000000
     AttitudeToPlayer=ATTITUDE_Ignore
     HitSound1=Sound'DeusExSounds.Player.MalePainSmall'
     HitSound2=Sound'DeusExSounds.Player.MalePainMedium'
     Die=Sound'DeusExSounds.Player.MaleDeath'
     NameArticle=""
     VisibilityThreshold=0.010000
     DrawType=DT_Mesh
     Mass=150.000000
     Buoyancy=155.000000
     BindName="HumanMilitary"
     bHateInjury=False
     bHateShot=False
     bHateDistress=False
     bHateCarcass=False
     bHateWeapon=False
}
